/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.registry;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.OreFeature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import org.betterx.bclib.api.v2.LifeCycleAPI;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeBuilder;
import org.betterx.bclib.api.v2.levelgen.biomes.BiomeAPI;
import org.betterx.bclib.api.v2.levelgen.structures.StructurePlacementType;
import org.betterx.bclib.api.v2.levelgen.structures.StructureWorldNBT;
import org.betterx.bclib.api.v3.levelgen.features.BCLFeature;
import org.betterx.bclib.api.v3.levelgen.features.BCLFeatureBuilder;
import org.betterx.bclib.api.v3.levelgen.features.BCLPlacedFeatureBuilder;
import org.betterx.bclib.api.v3.levelgen.features.config.TemplateFeatureConfig;
import org.betterx.betternether.BN;
import org.betterx.betternether.BetterNether;
import org.betterx.betternether.config.Configs;
import org.betterx.betternether.registry.NetherBlocks;
import org.betterx.betternether.registry.features.configured.NetherObjects;
import org.betterx.betternether.registry.features.configured.NetherTerrain;
import org.betterx.betternether.registry.features.configured.NetherTrees;
import org.betterx.betternether.registry.features.configured.NetherVegetation;
import org.betterx.betternether.registry.features.configured.NetherVines;
import org.betterx.betternether.registry.features.placed.NetherObjectsPlaced;
import org.betterx.betternether.registry.features.placed.NetherTerrainPlaced;
import org.betterx.betternether.registry.features.placed.NetherTreesPlaced;
import org.betterx.betternether.registry.features.placed.NetherVegetationPlaced;
import org.betterx.betternether.registry.features.placed.NetherVinesPlaced;
import org.betterx.betternether.world.features.AnchorTreeBranchFeature;
import org.betterx.betternether.world.features.AnchorTreeFeature;
import org.betterx.betternether.world.features.AnchorTreeRootFeature;
import org.betterx.betternether.world.features.BigBrownMushroomFeature;
import org.betterx.betternether.world.features.CavesFeature;
import org.betterx.betternether.world.features.CrystalFeature;
import org.betterx.betternether.world.features.JellyfishMushroomFeature;
import org.betterx.betternether.world.features.LucisFeature;
import org.betterx.betternether.world.features.MushroomFirFeature;
import org.betterx.betternether.world.features.NetherSakuraBushFeature;
import org.betterx.betternether.world.features.NetherSakuraFeature;
import org.betterx.betternether.world.features.OldWillowTree;
import org.betterx.betternether.world.features.PathsFeature;
import org.betterx.betternether.world.features.RubeusBushFeature;
import org.betterx.betternether.world.features.RubeusTreeFeature;
import org.betterx.betternether.world.features.SoulLilyFeature;
import org.betterx.betternether.world.features.TwistedVinesFeature;
import org.betterx.betternether.world.features.WartBushFeature;
import org.betterx.betternether.world.features.WartCapFeature;
import org.betterx.betternether.world.features.WartTreeFeature;
import org.betterx.betternether.world.features.WillowBushFeature;
import org.betterx.betternether.world.features.WillowTreeFeature;
import org.betterx.betternether.world.structures.city.CityStructure;

public class NetherFeatures {
    public static final Feature<NoneFeatureConfiguration> JELLYFISH_MUSHROOM = BCLFeature.register((ResourceLocation)BN.id("jellyfish_mushroom"), (Feature)new JellyfishMushroomFeature());
    public static final Feature<NoneFeatureConfiguration> OBSIDIAN_CRYSTAL = BCLFeature.register((ResourceLocation)BN.id("obsidian_crystal"), (Feature)new CrystalFeature());
    public static final Feature<NoneFeatureConfiguration> WART_BUSH = BCLFeature.register((ResourceLocation)BN.id("wart_bush"), (Feature)new WartBushFeature());
    public static final RubeusTreeFeature RUBEUS_TREE = (RubeusTreeFeature)BCLFeature.register((ResourceLocation)BN.id("rubeus_tree"), (Feature)new RubeusTreeFeature());
    public static final MushroomFirFeature MUSHROOM_FIR = (MushroomFirFeature)BCLFeature.register((ResourceLocation)BN.id("mushroom_fir"), (Feature)new MushroomFirFeature());
    public static final BigBrownMushroomFeature BIG_BROWN_MUSHROOM = (BigBrownMushroomFeature)BCLFeature.register((ResourceLocation)BN.id("big_brown_mushroom"), (Feature)new BigBrownMushroomFeature());
    public static final Feature<NoneFeatureConfiguration> RUBEUS_BUSH = BCLFeature.register((ResourceLocation)BN.id("rubeus_bush"), (Feature)new RubeusBushFeature());
    public static final Feature<NoneFeatureConfiguration> LUCIS = BCLFeature.register((ResourceLocation)BN.id("lucis"), (Feature)new LucisFeature());
    public static final SoulLilyFeature SOUL_LILY = (SoulLilyFeature)BCLFeature.register((ResourceLocation)BN.id("soul_lily"), (Feature)new SoulLilyFeature());
    public static final WartTreeFeature WART_TREE = (WartTreeFeature)BCLFeature.register((ResourceLocation)BN.id("wart_tree"), (Feature)new WartTreeFeature());
    public static final WillowBushFeature WILLOW_BUSH = (WillowBushFeature)BCLFeature.register((ResourceLocation)BN.id("willow_bush"), (Feature)new WillowBushFeature());
    public static final WillowTreeFeature WILLOW_TREE = (WillowTreeFeature)BCLFeature.register((ResourceLocation)BN.id("willow_tree"), (Feature)new WillowTreeFeature());
    public static final OldWillowTree OLD_WILLOW_TREE = (OldWillowTree)BCLFeature.register((ResourceLocation)BN.id("old_willow_tree"), (Feature)new OldWillowTree());
    public static final NetherSakuraFeature SAKURA_TREE = (NetherSakuraFeature)BCLFeature.register((ResourceLocation)BN.id("sakura_tree"), (Feature)new NetherSakuraFeature());
    public static final NetherSakuraBushFeature SAKURA_BUSH = (NetherSakuraBushFeature)BCLFeature.register((ResourceLocation)BN.id("sakura_bush"), (Feature)new NetherSakuraBushFeature());
    public static final AnchorTreeBranchFeature ANCHOR_TREE_BRANCH = (AnchorTreeBranchFeature)BCLFeature.register((ResourceLocation)BN.id("anchor_tree_branch"), (Feature)new AnchorTreeBranchFeature());
    public static final AnchorTreeFeature ANCHOR_TREE = (AnchorTreeFeature)BCLFeature.register((ResourceLocation)BN.id("anchor_tree"), (Feature)new AnchorTreeFeature());
    public static final AnchorTreeRootFeature ANCHOR_TREE_ROOT = (AnchorTreeRootFeature)BCLFeature.register((ResourceLocation)BN.id("anchor_tree_root"), (Feature)new AnchorTreeRootFeature());
    public static final WartCapFeature WART_CAP = (WartCapFeature)BCLFeature.register((ResourceLocation)BN.id("wart_cap"), (Feature)new WartCapFeature());
    public static final TwistedVinesFeature TWISTING_VINES = (TwistedVinesFeature)BCLFeature.register((ResourceLocation)BN.id("twisting_vines"), (Feature)new TwistedVinesFeature());
    private static final List<BCLFeature> defaultFeatures = Lists.newArrayList();
    public static final BCLFeature<OreFeature, OreConfiguration> CINCINNASITE_ORE = NetherFeatures.registerOre("cincinnasite", NetherBlocks.CINCINNASITE_ORE, 10, 8, 0.0f, PlacementUtils.f_195357_, false);
    public static final BCLFeature<OreFeature, OreConfiguration> NETHER_RUBY_ORE = NetherFeatures.registerOre("nether_ruby", NetherBlocks.NETHER_RUBY_ORE, 3, 8, 0.0f, (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158930_((int)32), (VerticalAnchor)VerticalAnchor.m_158935_((int)32)), false);
    public static final BCLFeature<OreFeature, OreConfiguration> NETHER_RUBY_ORE_SOUL = NetherFeatures.registerOre("nether_ruby_soul", NetherBlocks.NETHER_RUBY_ORE, Blocks.f_50136_, 5, 5, 0.1f, (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158930_((int)32), (VerticalAnchor)VerticalAnchor.m_158929_()), false);
    public static final BCLFeature<OreFeature, OreConfiguration> NETHER_RUBY_ORE_LARGE = NetherFeatures.registerOre("nether_ruby_large", NetherBlocks.NETHER_RUBY_ORE, 5, 5, 0.1f, (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158930_((int)32), (VerticalAnchor)VerticalAnchor.m_158929_()), false);
    public static final BCLFeature<OreFeature, OreConfiguration> NETHER_RUBY_ORE_RARE = NetherFeatures.registerOre("nether_ruby_rare", NetherBlocks.NETHER_RUBY_ORE, 2, 12, 0.0f, (PlacementModifier)HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158930_((int)70), (VerticalAnchor)VerticalAnchor.m_158929_()), true);
    public static final BCLFeature<OreFeature, OreConfiguration> NETHER_LAPIS_ORE = NetherFeatures.registerOre("nether_lapis", NetherBlocks.NETHER_LAPIS_ORE, 14, 4, 0.0f, (PlacementModifier)HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158930_((int)32), (VerticalAnchor)VerticalAnchor.m_158935_((int)10)), false);
    public static final BCLFeature<OreFeature, OreConfiguration> NETHER_REDSTONE_ORE = NetherFeatures.registerOre("nether_redstone", NetherBlocks.NETHER_REDSTONE_ORE, 1, 16, 0.3f, (PlacementModifier)HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158930_((int)8), (VerticalAnchor)VerticalAnchor.m_158930_((int)40)), true);

    private static BCLFeature<OreFeature, OreConfiguration> registerOre(String name, Block blockOre, Block baseBlock, int veins, int veinSize, float airDiscardChance, PlacementModifier placement, boolean rare) {
        int veins1 = Configs.GENERATOR.getInt("generator.world.ores." + name, "vein_count", veins);
        BCLPlacedFeatureBuilder builder = BCLFeatureBuilder.startOre((ResourceLocation)BetterNether.makeID(name + "_ore")).add(baseBlock, blockOre).veinSize(Configs.GENERATOR.getInt("generator.world.ores." + name, "vein_size", veinSize)).discardChanceOnAirExposure(Configs.GENERATOR.getFloat("generator.world.ores." + name, "air_discard_chance", airDiscardChance)).build().place().decoration(GenerationStep.Decoration.UNDERGROUND_DECORATION);
        if (rare) {
            builder.onceEvery(veins1);
        } else {
            builder.count(veins1);
        }
        ((BCLPlacedFeatureBuilder)((BCLPlacedFeatureBuilder)builder.modifier(new PlacementModifier[]{placement})).squarePlacement()).onlyInBiome();
        return builder.build();
    }

    private static BCLFeature<OreFeature, OreConfiguration> registerOre(String name, Block blockOre, int veins, int veinSize, float airDiscardChance, PlacementModifier placement, boolean rare) {
        return NetherFeatures.registerOre(name, blockOre, Blocks.f_50134_, veins, veinSize, airDiscardChance, placement, rare);
    }

    public static StructureWorldNBT cfg(ResourceLocation location, int offsetY, StructurePlacementType type, float chance) {
        return TemplateFeatureConfig.cfg((ResourceLocation)location, (int)offsetY, (StructurePlacementType)type, (float)chance);
    }

    public static BCLBiomeBuilder addDefaultFeatures(BCLBiomeBuilder builder) {
        return builder;
    }

    public static void addDefaultBNFeatures(BCLBiomeBuilder builder) {
        for (BCLFeature f : defaultFeatures) {
            builder.feature(f);
        }
    }

    public static BCLBiomeBuilder addDefaultOres(BCLBiomeBuilder builder) {
        return builder.feature(CINCINNASITE_ORE).feature(NETHER_RUBY_ORE_RARE).feature(NETHER_LAPIS_ORE).feature(NETHER_REDSTONE_ORE);
    }

    public static void modifyNonBNBiome(ResourceLocation biomeID, Holder<Biome> biome) {
        BiomeAPI.addBiomeFeature(biome, CINCINNASITE_ORE);
        BiomeAPI.addBiomeFeature(biome, NETHER_RUBY_ORE_RARE);
        BiomeAPI.addBiomeFeature(biome, NETHER_LAPIS_ORE);
        BiomeAPI.addBiomeFeature(biome, NETHER_REDSTONE_ORE);
        if (biomeID.equals((Object)BiomeAPI.SOUL_SAND_VALLEY_BIOME.getID())) {
            BiomeAPI.addBiomeFeature(biome, NETHER_RUBY_ORE_LARGE);
        }
        if (biomeID.equals((Object)BiomeAPI.CRIMSON_FOREST_BIOME.getID()) || biomeID.equals((Object)BiomeAPI.WARPED_FOREST_BIOME.getID())) {
            BiomeAPI.addBiomeFeature(biome, NETHER_RUBY_ORE);
        }
    }

    public static void register() {
        NetherVegetation.ensureStaticInitialization();
        NetherVegetationPlaced.ensureStaticInitialization();
        NetherVines.ensureStaticInitialization();
        NetherVinesPlaced.ensureStaticInitialization();
        NetherTrees.ensureStaticInitialization();
        NetherTreesPlaced.ensureStaticInitialization();
        NetherObjects.ensureStaticInitialization();
        NetherObjectsPlaced.ensureStaticInitialization();
        NetherTerrain.ensureStaticInitialization();
        NetherTerrainPlaced.ensureStaticInitialization();
        LifeCycleAPI.onLevelLoad(NetherFeatures::onWorldLoad);
    }

    public static void onWorldLoad(ServerLevel level, long seed, Registry<Biome> registry) {
        CavesFeature.onLoad(seed);
        PathsFeature.onLoad(seed);
        CityStructure.initGenerator();
    }
}

